/*------------------------------------------------------------------------------*
 * File Name: MatObjChooser.h													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *  SY 03/28/2006 QA70-7885 v8.0383 MATRIX_MULTIPLE_OBJECTS_GUI					*
 *  Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING								*
 *	Folger 09/07/09 MATRIX_OBJECTS_SCROLL_BAR_MAKES_RUNTIME_ERROR_WHEN_NO_SHEET_IN_PAGE
 *------------------------------------------------------------------------------*/

#ifndef _MATOBJCHOOSER_H_
#define _MATOBJCHOOSER_H_

////////////////////////////////////////////////////////////////////////////////
// The following labtalk code for test only
// def MatBar {if("%1"!="C")  page -sps "r[MatObjChooser]{130}r";else page -sps;}
// 
////////////////////////////////////////////////////////////////////////////////
class OC_REGISTERED MatObjChooser : public ResizeDialog
{
public:
	MatObjChooser() : ResizeDialog(IDD_MATOBJ_DLG, "Odlg8")
	{
		///------ Folger 09/07/09 MATRIX_OBJECTS_SCROLL_BAR_MAKES_RUNTIME_ERROR_WHEN_NO_SHEET_IN_PAGE
		//m_pg = Project.ActiveLayer().GetPage();		///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
		Layer	lay = Project.ActiveLayer();
		if ( lay )
			m_pg = lay.GetPage();
		///------ End MATRIX_OBJECTS_SCROLL_BAR_MAKES_RUNTIME_ERROR_WHEN_NO_SHEET_IN_PAGE
	}

	~MatObjChooser()
	{
	}
	
	virtual int Create(HWND hParent = NULL)
	{
		InitMsgMap();
		//Launch the modeless dialog
		int nRet = Dialog::Create(hParent);
		Visible=true;	
		return nRet;
	}

	BOOL CreateWindow(int nID, HWND hWnd)
	{
		InitMsgMap();
		int nRet = Dialog::Create(hWnd, DLG_AS_CHILD);
		HWND hWndThis = GetSafeHwnd();
		SetWindowLong(hWndThis, GWL_ID, nID);
		return nRet;
	}

protected:
///----------------- Message Map ----------------
	EVENTS_BEGIN
		ON_INIT(OnInitDialog) 
		ON_SIZE(OnDlgResize)
		ON_PAGE_SPLITTER_READY(OnReady)
		ON_BN_CLICKED(IDC_BTN_CLOSE, OnClose)
		ON_SLIDE(IDC_MATOBJ_INDEX, OnClickSlider)
		///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
		//ON_CHANGE_LAYER( OnActiveLayerChange )
		ON_CHANGE_DATASET( OnChangeDataset )
		///End FIX_BUG_AND_ADD_TEMPLATE_SAVING
	EVENTS_END
///----------------------------------------------
	
	BOOL OnInitDialog()
	{
		BASE_WINDOW::OnInitDialog();
		
		m_slider = GetItem(IDC_MATOBJ_INDEX);
		//---- CPY 5/19/06 NICER_LOOKING_SLIDER_THUMB
		int width = m_slider.SendMessage(TBM_GETTHUMBLENGTH, 0, 0);	
		width /=4;
		m_slider.SendMessage(TBM_SETTHUMBLENGTH, width, 0);
		//----
		//m_staticSlider = GetItem(IDC_MATOBJ_ST_INDEX);		
		//m_edLongName = GetItem(IDC_MATOBJ_LONGNAME);
		//m_edUnits = GetItem(IDC_MATOBJ_UNITS);
		m_edComments = GetItem(IDC_MATOBJ_COMMENTS);
		
		return TRUE;
	}
	BOOL OnClose(Control ctrl)
	{
		LT_execute(";mbar c");
		return true;
	}	
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		if( !IsInitReady() )
			return TRUE;
		bool bFlag = false;
		if (m_slider.Visible == false)
		{
			bFlag = m_slider.Visible = true;
		}
		uint uTopItems[] = {IDC_MATOBJ_INDEX, IDC_BTN_CLOSE, 0}
//		int ny = PositionControl(IDC_MATOBJ_INDEX,0,0);
//		SizeControl(IDC_MATOBJ_INDEX, cx);
		int ny = ArrangeControlsLeftRight(uTopItems, 0, 0, cx, IDC_MATOBJ_INDEX);
		RECT rr = {0};
		rr.top = ny + 4;
		rr.right = cx;
		rr.bottom = cy + 3;
		MoveControl(m_edComments, rr);
		//-----
		if (bFlag) m_slider.Visible = false;
		return TRUE;
	}
	
	BOOL OnClickSlider(Control ctrl, UINT nCode, UINT nPos)
	{
		SetActive(m_slider.Position);		///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
		return ShowLabel(m_slider.Position);
	}

	BOOL OnReady()
	{
		SetInitReady();
		OnDlgResize(0, GetDlgExtent(false), GetDlgExtent(true));
		setup();
		return true;
	}
	
	BOOL OnDestroy()
	{
		return BASE_WINDOW::OnDestroy();
	}
	///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
	//BOOL OnActiveLayerChange()
	//{
		//setup();
		//return true;
	//}
	
	BOOL OnChangeDataset()
	{
		setup();
		return true;
	}
	
	#define PAGE_NAME    		 "PageName"
	#define STR_SLIDER_BIN_STORE "Slider"
	BOOL GetSettings(TreeNode &nodeSettings, Page &page)
	{
		//if(nodeSettings)
		//{
			//SaveState();
			//TreeNode tn = nodeSettings.AddNode(PAGE_NAME);
			//tn.strVal = m_pg.GetName();
		//}
    	return TRUE;
	}	 
	BOOL SetSettings(TreeNode &nodeSettings, Page &page)
	{
		if(nodeSettings)
		{
	  		if(page)// open project will have invalif page
	  		{
	  			m_pg = page; 
	  		}
		}
		return TRUE;
	}
	///End FIX_BUG_AND_ADD_TEMPLATE_SAVING
private:	
	
	void setup()
	{
		///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
		///MatrixLayer ml = Project.ActiveLayer();
 		MatrixLayer ml = m_pg.Layers();
		///End FIX_BUG_AND_ADD_TEMPLATE_SAVING
		if( ml )
		{
			int nMatObjs = ml.MatrixObjects.Count();
			int nCurObj = ml.GetActive();
			
			if( nMatObjs > 1 )
			{
				m_slider.Visible = true;		///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
				m_slider.RangeMin = 0;
				m_slider.RangeMax = nMatObjs-1;
				m_slider.Position = nCurObj;
			}
			else
			{
				m_slider.Visible = false;
				//m_staticSlider.Visible = false;
			}
			ShowLabel(nCurObj);
		}
		///------ Folger 09/07/09 MATRIX_OBJECTS_SCROLL_BAR_MAKES_RUNTIME_ERROR_WHEN_NO_SHEET_IN_PAGE
		else
			m_slider.Visible = false;
		///------ End MATRIX_OBJECTS_SCROLL_BAR_MAKES_RUNTIME_ERROR_WHEN_NO_SHEET_IN_PAGE
			
		m_slider.SetTicFreq(1);				///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
	}
	///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
	BOOL SetActive(int nMatObjIndex)
	{
		MatrixLayer ml = m_pg.Layers();
		ml.SetActive(nMatObjIndex);
		return true;
	}
	///End FIX_BUG_AND_ADD_TEMPLATE_SAVING
public:
	
	BOOL ShowLabel(int nMatObjIndex)
	{
		///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
		///MatrixLayer ml = Project.ActiveLayer();
		MatrixLayer ml = m_pg.Layers();
		///End FIX_BUG_AND_ADD_TEMPLATE_SAVING
		if( ml )
		{
//			ml.SetActive(nMatObjIndex);			///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
			MatrixObject mo = ml.MatrixObjects(nMatObjIndex);
			//---- CPY 4/2/06 MAKE_DLG_SMALLER_WITH_ONE_EDIT_BOX
			//m_edLongName.Text = mo.GetLongName();
			//m_edUnits.Text = mo.GetUnits(); // not sure
			//m_edComments.Text = mo.GetComments();
			string str = mo.GetLongName();
//			string strUnits = mo.GetUnits();
//			if(!strUnits.IsEmpty())
//				str += "(" + strUnits + ")";
			
			string strComments = mo.GetComments();
			if(!strComments.IsEmpty())
				str += "\r\n" + strComments;
			m_edComments.Text = str;
			//----
			return TRUE;
		}
		return FALSE;
	}

private:
	
//	Edit m_edLongName;
//	Edit m_edUnits;
	Edit m_edComments;
	Slider 	m_slider;
	Page m_pg;			///Folger 04/19/07 FIX_BUG_AND_ADD_TEMPLATE_SAVING
//	Control	m_staticSlider;
};

#endif // _MATOBJCHOOSER_H_